﻿<?php
// Define o cabeçalho para garantir que a resposta seja um JSON
header('Content-Type: application/json');

// Obtém e sanitiza o parâmetro 'nome' da URL
$nome = isset($_GET['nome']) ? trim($_GET['nome']) : '';

// Inicializa a estrutura de resposta JSON
$resposta = [
    'sucesso' => false,
    'mensagem' => '',
    'parametro' => [
        'nome' => $nome
    ],
    'dados' => []
];

// Valida se o parâmetro 'nome' foi fornecido
if (empty($nome)) {
    $resposta['mensagem'] = 'Parâmetro "nome" é obrigatório.';
    echo json_encode($resposta, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;
}

// Faz a requisição GET para o endpoint do Python
$apiUrl = 'http://localhost:5000/?nome=' . urlencode($nome);
$ch = curl_init($apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json'
]);
$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// Verifica se a requisição foi bem-sucedida
if ($response === false || $http_code !== 200) {
    $resposta['mensagem'] = 'Erro ao consultar a API local: ' . ($response === false ? curl_error($ch) : 'Código HTTP ' . $http_code);
    echo json_encode($resposta, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;
}

// Decodifica a resposta da API
$api_data = json_decode($response, true);
if (!$api_data) {
    $resposta['mensagem'] = 'Erro ao decodificar a resposta da API local.';
    echo json_encode($resposta, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;
}

// Usa a resposta da API diretamente
$resposta = $api_data;

// Salva a resposta JSON em um arquivo
$diretorio = 'logs';
if (!is_dir($diretorio)) {
    mkdir($diretorio, 0777, true);
}
$json_data = json_encode($resposta, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
$nome_arquivo = $diretorio . '/' . str_replace(' ', '_', $nome) . '.json';
file_put_contents($nome_arquivo, $json_data);

// Exibe a resposta final
echo $json_data;
?>