﻿import io
import re
from datetime import datetime
from flask import Flask, request, send_file, make_response
import fitz  # PyMuPDF

app = Flask(__name__)

# Carregar modelo PDF uma vez (em memória)
with open("modelo.pdf", "rb") as f:
    modelo_pdf_bytes = f.read()


def formatar_data():
    meses = [
        "Janeiro", "Fevereiro", "Março", "Abril", "Maio", "Junho",
        "Julho", "Agosto", "Setembro", "Outubro", "Novembro", "Dezembro"
    ]
    data_atual = datetime.now()
    return f"{data_atual.day} de {meses[data_atual.month - 1]} de {data_atual.year}."


def formatar_valor_para_texto(valor_str):
    return re.sub(r'\s+', '', valor_str)


def adicionar_texto_pdf(dados):
    # Abre a cópia do modelo em memória (sem tocar o disco)
    doc = fitz.open(stream=modelo_pdf_bytes, filetype="pdf")
    page = doc.load_page(0)

    x, y = 72, 72 + (28.35 * 7)

    page.insert_text((x, y), f"Credor: {dados['parte1_nome']}", fontsize=12, fontname="helv"); y += 14
    page.insert_text((x, y), f"CPF/CNPJ: {dados['parte1_cpf']}", fontsize=12, fontname="helv"); y += 14
    page.insert_text((x, y), f"Advogado(a): {dados['parte1_advogado']}", fontsize=12, fontname="helv"); y += 28
    page.insert_text((x, y), f"Processo N°: {dados['processo']}", fontsize=12, fontname="helv"); y += 28
    page.insert_text((x, y), f"CUMPRIMENTO DE SENTENÇA CONTRA: {dados['parte2_nome']}", fontsize=12, fontname="helv"); y += 14
    page.insert_text((x, y), "Assunto: Decisão Favorável", fontsize=12, fontname="helv"); y += 14
    page.insert_text((x, y), "Situação: AUTORIZADO", fontsize=12, fontname="helv"); y += 42

    valor_formatado = formatar_valor_para_texto(dados['valor_a_receber'])
    page.insert_text((x, y), f"Valor a receber: {valor_formatado} será depositado em conta corrente de sua titularidade.", fontsize=12, fontname="helv"); y += 28
    page.insert_text((x, y), "Os autos foram encaminhados pelo TJ à Vara da Fazenda...", fontsize=12, fontname="helv"); y += 14
    page.insert_text((x, y), "posteriormente encaminhado para Vara das Execuções...", fontsize=12, fontname="helv"); y += 28

    page.insert_text((x, y), formatar_data(), fontsize=12, fontname="helv")

    return doc


@app.route('/gerar_oficio', methods=['GET'])
def gerar_oficio_endpoint():
    dados = {
        "parte1_nome": request.args.get('credor', '').strip(),
        "parte1_cpf": request.args.get('cpf', '').strip(),
        "parte1_advogado": request.args.get('advogado', '').strip(),
        "processo": request.args.get('processo', '').strip(),
        "parte2_nome": request.args.get('parte_contraria', '').strip(),
        "valor_a_receber": request.args.get('valor', '').strip()
    }

    if not dados["parte1_nome"]:
        return make_response("Erro: O parâmetro 'credor' é obrigatório.", 400)
    if not dados["processo"]:
        return make_response("Erro: O parâmetro 'processo' é obrigatório.", 400)
    if not dados["valor_a_receber"]:
        return make_response("Erro: O parâmetro 'valor' é obrigatório.", 400)

    try:
        doc = adicionar_texto_pdf(dados)
        pdf_buffer = io.BytesIO()
        doc.save(pdf_buffer)
        doc.close()
        pdf_buffer.seek(0)

        nome_arquivo_seguro = re.sub(r'[^a-zA-Z0-9_ ]', '', dados['parte1_nome'])[:50]
        nome_arquivo_final = f"STJ_{nome_arquivo_seguro.strip().replace(' ', '_')}.pdf"

        return send_file(pdf_buffer, mimetype='application/pdf',
                         as_attachment=False, download_name=nome_arquivo_final)
    except Exception as e:
        return make_response(f"Erro interno ao gerar o PDF: {str(e)}", 500)


if __name__ == '__main__':
    # Apenas para testes locais, em produção usar Gunicorn
    app.run(host='0.0.0.0', port=7261, debug=False, threaded=True)
