﻿from flask import Flask, request, jsonify
import requests
import json
import base64
from urllib.parse import urljoin
from io import StringIO
import sys

app = Flask(__name__)

# Proxy (conforme solicitado)
PROXY = "http://proxy-agu2v1m8hqwu_area-BR_session-hxsdjN4iuK_life-5:ptJ9cB6SoZYcN1go@us.naproxy.net:1000"
PROXIES = {
    "http": PROXY,
    "https": PROXY,   # obrigatório p/ HTTPS
}

# Timeout padrão (em segundos) para requisições
DEFAULT_TIMEOUT = 15

def search_oab(nome_advo):
    # Buffer para capturar saída do console
    output_buffer = StringIO()
    sys.stdout = output_buffer

    # Sessão com proxy aplicado
    session = requests.Session()
    session.proxies.update(PROXIES)
    session.trust_env = False  # garante que não use variáveis do SO

    headers_post = {
        "Accept": "*/*",
        "Accept-Encoding": "gzip, deflate, br, zstd",
        "Accept-Language": "pt-BR,pt;q=0.9,en-US;q=0.8,en;q=0.7",
        "Connection": "keep-alive",
        "Content-Type": "application/x-www-form-urlencoded; charset=UTF-8",
        "Cookie": "__RequestVerificationToken=JVPSeU9K4W-lOTGTabR49kPQ8xWp4sMzT0wPd2DrDA672G42UxRGhxNp61kuvab6fcDvmouGoxqeB-FQRVMnaiXaGwijlUv5GG0rT30T9R41",
        "Host": "cna.oab.org.br",
        "Origin": "https://cna.oab.org.br",
        "Referer": "https://cna.oab.org.br/",
        "RequestVerificationToken": "TkmMUBUG8bG_DebOYHoQBzOJJaZIv7fKku7lHD4WmwunKTIyr6zM4_PhXJ4X7-lGmU1m4EhcBx5WbtCpyMnQUJTeQ-GV_tmQFzJMqnqtPpM1:XZMK7thNL9NabHYZeWTc9hXGs3v6y6FN2STF7-whBHDhUs-E06bo8V4kM64EO9Ubh1_V3e7Twrcv_-ESGn6HamWvRvLMvmdTWoZxzUbJEr81",
        "sec-ch-ua": '"Chromium";v="140", "Not=A?Brand";v="24", "Google Chrome";v="140"',
        "sec-ch-ua-mobile": "?0",
        "sec-ch-ua-platform": '"Windows"',
        "Sec-Fetch-Dest": "empty",
        "Sec-Fetch-Mode": "cors",
        "Sec-Fetch-Site": "same-origin",
        "User-Agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36",
        "X-Requested-With": "XMLHttpRequest"
    }

    form_data = {
        "__RequestVerificationToken": "AWnmJFktWLuQHhxmI4BO_pxff3DUacU_XCiHEzdEW4WzenylagLyNQw7PnjTM63m2TFL5P1EmeP1ujWzimwc02xm_2eiYKlscDEYQRw8GNE1",
        "IsMobile": "false",
        "NomeAdvo": nome_advo,
        "Insc": "",
        "Uf": "",
        "TipoInsc": ""
    }

    first_url = "https://cna.oab.org.br/Home/Search"

    try:
        # Primeira requisição
        resp1 = session.post(first_url, headers=headers_post, data=form_data, timeout=DEFAULT_TIMEOUT)
        resp1.raise_for_status()

        first_response_data = resp1.json()
        data = first_response_data.get("Data", [])
        if not data or not isinstance(data, list) or not data[0].get("DetailUrl"):
            raise ValueError("DetailUrl not found in the first response")

        first_detail_url = data[0]["DetailUrl"]
        second_url = urljoin("https://cna.oab.org.br", first_detail_url)

        # Segunda requisição
        headers_get = {
            "Accept": "*/*",
            "User-Agent": headers_post["User-Agent"],
            "Cookie": headers_post.get("Cookie", "")
        }
        resp2 = session.get(second_url, headers=headers_get, timeout=DEFAULT_TIMEOUT)
        resp2.raise_for_status()
        second_response_data = resp2.json()

        # Terceira requisição (imagem)
        second_detail_url = second_response_data.get("Data", {}).get("DetailUrl", "")
        third_url = urljoin("https://cna.oab.org.br", second_detail_url)
        resp3 = session.get(third_url, headers=headers_get, timeout=DEFAULT_TIMEOUT)
        resp3.raise_for_status()
        base64_image = base64.b64encode(resp3.content).decode("utf-8")

        uf_from_second = second_response_data.get("Data", {}).get("UF", data[0].get("Uf", ""))

        output = {
            "sucesso": True,
            "mensagem": "",
            "parametro": {
                "nome": nome_advo,
                "oab": data[0].get("Inscricao", ""),
                "uf": uf_from_second
            },
            "dados": [
                {
                    "Nome": data[0].get("Nome", ""),
                    "Inscricao": data[0].get("Inscricao", ""),
                    "Uf": uf_from_second,
                    "Situacao": data[0].get("Situacao", ""),
                    "TipoInscricao": data[0].get("TipoInsc", ""),
                    "DetailUrl": data[0].get("DetailUrl", "")
                }
            ],
            "base64_image": base64_image,
            "first_response": first_response_data
        }

        sys.stdout = sys.__stdout__
        output_buffer.close()
        return output

    except Exception as e:
        sys.stdout = sys.__stdout__
        output_buffer.close()
        return {
            "sucesso": False,
            "mensagem": str(e),
            "parametro": {"nome": nome_advo, "oab": "", "uf": ""},
            "dados": [],
            "base64_image": "",
            "first_response": {}
        }

@app.route('/search', methods=['GET'])
def search():
    nome_advo = request.args.get('nome_advo', '').strip()
    if not nome_advo:
        return jsonify({
            "sucesso": False,
            "mensagem": "Nome vazio. Forneça o parâmetro 'nome_advo' na query string.",
            "parametro": {"nome": "", "oab": "", "uf": ""},
            "dados": [],
            "base64_image": "",
            "first_response": {}
        }), 400
    
    result = search_oab(nome_advo)
    return jsonify(result)

if __name__ == "__main__":
    app.run(debug=True, port=8171)
