﻿from flask import Flask, request, jsonify
import requests
import re
import json
import os
import datetime
import base64
from datetime import datetime as dt
import time
app = Flask(__name__)
# -------------------------
# Configuração do proxy
# -------------------------
PROXY = {
    'http': 'http://proxy-agu2v1m8hqwu_area-BR_session-hxsdjN4iuK_life-5:ptJ9cB6SoZYcN1go@us.naproxy.net:1000',
    "https":'http://proxy-agu2v1m8hqwu_area-BR_session-hxsdjN4iuK_life-5:ptJ9cB6SoZYcN1go@us.naproxy.net:1000',

}


USE_PROXY = True
TOKEN_FILE = "token.json"
# -------------------------
# Funções auxiliares
# -------------------------
def salvar_log(resposta, respostas_brutas, rota=""):
    diretorio = 'logs'
    arquivo_log = os.path.join(diretorio, 'logs.json')
    if not os.path.exists(diretorio):
        os.makedirs(diretorio)
    logs = []
    if os.path.exists(arquivo_log):
        try:
            with open(arquivo_log, 'r', encoding='utf-8') as f:
                logs = json.load(f)
        except (json.JSONDecodeError, UnicodeDecodeError, IOError) as e:
            print(f"Error loading logs: {e}")
            logs = []
    logs.append({
        'timestamp': datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S'),
        'rota': rota,
        'resposta': resposta,
        'respostas_brutas': respostas_brutas
    })
    try:
        with open(arquivo_log, 'w', encoding='utf-8') as f:
            json.dump(logs, f, ensure_ascii=False, indent=4)
    except Exception as e:
        print(f"Error saving logs: {e}")
def make_request(method, url, retries=3, backoff=5, **kwargs):
    """
    Faz requisições sempre via proxy, com tentativas extras em caso de erro.
    - retries: número máximo de tentativas
    - backoff: tempo (em segundos) entre tentativas quando erro 429
    """
    session = requests.Session()
    if USE_PROXY:
        session.proxies.update(PROXY)
    last_error = None
    for attempt in range(1, retries + 1):
        try:
            response = session.request(method, url, timeout=30, **kwargs)
            # Se status 429 (Too Many Requests), espera e tenta de novo
            if response.status_code == 429:
                time.sleep(backoff * attempt) # backoff progressivo
                continue
            response.raise_for_status()
            return response
        except requests.RequestException as e:
            last_error = e
            # Aguarda antes de tentar novamente (para outros erros temporários)
            time.sleep(2 * attempt)
    # Se chegou aqui, todas as tentativas falharam
    raise RuntimeError(f"Erro na requisição para {url} após {retries} tentativas: {last_error}")
def get_token():
    bearer = request.args.get("bearer") or request.form.get("bearer")
    if bearer:
        bearer_token = "Bearer " + bearer
        token_data = {
            "token": bearer_token,
            "created_at": datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S"),
            "expires_in": ""
        }
        with open(TOKEN_FILE, "w", encoding="utf-8") as f:
            json.dump(token_data, f, indent=4, ensure_ascii=False)
        return bearer_token
    if os.path.exists(TOKEN_FILE):
        token_data = json.load(open(TOKEN_FILE, "r", encoding="utf-8"))
        return token_data.get("token")
    return None
def consultar_api(url, headers):
    try:
        resp = make_request("GET", url, headers=headers)
        return {"rota": url, "status": resp.status_code, "online": True, "body": resp.text, "erro": ""}
    except Exception as e:
        return {"rota": url, "status": 0, "online": False, "body": "", "erro": str(e)}
# -------------------------
# Funções herdadas do PHP
# -------------------------
def processar_partes(tramitacao_atual, cpf_cnpj="", advogado_principal="", oab_numero="", oab_uf="", consulta_tipo=""):
    polo_ativo, polo_passivo, advogados = [], [], []
    contagem_ativo = contagem_passivo = 0
    advogado_no_polo_ativo = advogado_no_polo_passivo = advogado_como_parte_ativa = False
    partes = tramitacao_atual.get("partes", [])
    if isinstance(partes, list):
        for parte in partes:
            polo = parte.get("polo")
            nome = parte.get("nome")
            if not polo or not nome:
                continue
            documento_parte = ""
            docs_principais = parte.get("documentosPrincipais", [])
            if isinstance(docs_principais, list):
                for doc in docs_principais:
                    if doc.get("tipo") in ["CPF", "CNPJ"]:
                        documento_parte = doc.get("numero")
                        break
            string_parte = nome + (f" (Doc: {documento_parte})" if documento_parte else "")
            if polo == "ATIVO":
                polo_ativo.append(string_parte)
                if consulta_tipo == "CPF" and cpf_cnpj and documento_parte == cpf_cnpj:
                    contagem_ativo = 1
                representantes = parte.get("representantes", [])
                if isinstance(representantes, list):
                    for representante in representantes:
                        if representante.get("tipoRepresentacao") == "ADVOGADO":
                            nome_adv = representante.get("nome", "N/A")
                            cpf_adv = "N/A"
                            cadastro_rf = representante.get("cadastroReceitaFederal", [])
                            if isinstance(cadastro_rf, list):
                                for doc_adv in cadastro_rf:
                                    if doc_adv.get("tipo") == "CPF":
                                        cpf_adv = doc_adv.get("numero")
                                        break
                            adv_string = f"Advogado: {nome_adv}" + (f" (CPF: {cpf_adv})" if cpf_adv != "N/A" else "")
                            advogados.append(adv_string)
                            oab_list = representante.get("oab", [])
                            if isinstance(oab_list, list):
                                for oab_info in oab_list:
                                    if str(oab_info.get("numero", "")) == oab_numero and oab_info.get("uf") == oab_uf:
                                        advogado_no_polo_ativo = True
            elif polo == "PASSIVO":
                polo_passivo.append(string_parte)
                if consulta_tipo == "CPF" and cpf_cnpj and documento_parte == cpf_cnpj:
                    contagem_passivo = 1
    if consulta_tipo == "OAB" and advogado_principal:
        if advogado_principal in "; ".join(polo_passivo):
            advogado_no_polo_passivo = True
            contagem_passivo = 1
        if advogado_principal in "; ".join(polo_ativo):
            advogado_como_parte_ativa = True
        if advogado_no_polo_ativo and not advogado_como_parte_ativa:
            contagem_ativo = 1
    return {
        "poloAtivo": "; ".join(polo_ativo) or "N/A",
        "poloPassivo": "; ".join(polo_passivo) or "N/A",
        "advogados": "; ".join(advogados) or "N/A",
        "contagemAtivo": contagem_ativo,
        "contagemPassivo": contagem_passivo,
        "advogadoNoPoloAtivo": advogado_no_polo_ativo,
        "advogadoNoPoloPassivo": advogado_no_polo_passivo,
        "advogadoComoParteAtiva": advogado_como_parte_ativa
    }
def format_date(date_str):
    if not date_str or date_str == "N/A":
        return "N/A"
    try:
        dt_obj = dt.fromisoformat(date_str.replace("Z", "").replace(" ", "T"))
        return dt_obj.strftime("%d/%m/%Y %H:%M")
    except ValueError:
        try:
            dt_obj = dt.strptime(date_str, "%Y-%m-%d %H:%M:%S")
            return dt_obj.strftime("%d/%m/%Y %H:%M")
        except ValueError:
            return "N/A"
def formatar_processo(p, tramitacao_atual, partes):
    valor_acao = tramitacao_atual.get("valorAcao", 0)
    if not isinstance(valor_acao, (int, float)):
        valor_acao = 0
    valor_formatado = f"R$ {valor_acao:,.2f}".replace(",", "X").replace(".", ",").replace("X", ".")
    classe = (tramitacao_atual.get("classe", [{}])[0].get("descricao", "N/A"))
    assunto = (tramitacao_atual.get("assunto", [{}])[0].get("descricao", "N/A"))
    data_ultimo_mov = format_date(tramitacao_atual.get("ultimoMovimento", {}).get("dataHora", "N/A"))
    return {
        "Detalhes do Processo": {
            "Número do Processo": p.get("numeroProcesso", "N/A"),
            "Tribunal": tramitacao_atual.get("tribunal", {}).get("nome", "N/A"),
            "Órgão Julgador": tramitacao_atual.get("orgaoJulgador", {}).get("nome", "N/A"),
            "Classe": classe,
            "Assunto": assunto,
            "Valor da Ação": valor_formatado,
            "Data do Último Movimento": data_ultimo_mov
        },
        "Polo Ativo": {
            "Parte": partes["poloAtivo"],
            "Advogado": partes["advogados"]
        },
        "Polo Passivo": {
            "Parte": partes["poloPassivo"]
        }
    }
# -------------------------
# Rota CNA OAB (/)
# -------------------------
@app.route('/', methods=['GET'])
def main():
    nome = request.args.get('nome', '').strip()
    oab = request.args.get('oab', '').strip()
    uf = request.args.get('uf', '').strip()
    resposta = {
        'sucesso': False,
        'mensagem': '',
        'parametro': {'nome': nome, 'oab': oab, 'uf': uf},
        'dados': [],
        'base64_image': [],
        'first_response': {}
    }
    respostas_brutas = {}
    if not nome and not oab:
        resposta['mensagem'] = 'Parâmetro "nome" ou "oab" é obrigatório.'
        salvar_log(resposta, respostas_brutas, rota="/")
        return jsonify(resposta), 400
    headers_post = {
        "Accept": "*/*",
        "Accept-Encoding": "gzip, deflate, br, zstd",
        "Accept-Language": "pt-BR,pt;q=0.9,en-US;q=0.8,en;q=0.7",
        "Connection": "keep-alive",
        "Content-Type": "application/x-www-form-urlencoded; charset=UTF-8",
        "Host": "cna.oab.org.br",
        "Origin": "https://cna.oab.org.br",
        "Referer": "https://cna.oab.org.br/",
        "sec-ch-ua": '"Chromium";v="140", "Not=A?Brand";v="24", "Google Chrome";v="140"',
        "sec-ch-ua-mobile": "?0",
        "sec-ch-ua-platform": '"Windows"',
        "Sec-Fetch-Dest": "empty",
        "Sec-Fetch-Mode": "cors",
        "Sec-Fetch-Site": "same-origin",
        "User-Agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36",
        "X-Requested-With": "XMLHttpRequest"
    }
    post_data = {
        "IsMobile": "false",
        "NomeAdvo": nome.strip(),
        "Insc": oab.strip(),
        "Uf": uf.strip(),
        "TipoInsc": ""
    }
    post_url = "https://cna.oab.org.br/Home/Search"
    # Criar uma sessão com proxy explicitamente configurado
    session = requests.Session()
    if USE_PROXY:
        session.proxies.update(PROXY)
    try:
        # 1. POST /Home/Search
        response = make_request("POST", post_url, headers=headers_post, data=post_data)
        respostas_brutas["post_search"] = {"rota": post_url, "status": response.status_code, "body": response.text[:1000], "online": True, "erro": ""}
        try:
            data = response.json()
            resposta['first_response'] = data
        except ValueError as e:
            respostas_brutas["post_search"]["erro"] = f"JSON parsing error: {str(e)}"
            resposta['mensagem'] = 'Resposta não é um JSON válido.'
            salvar_log(resposta, respostas_brutas, rota="/")
            return jsonify(resposta), 500
        if not data.get("Data"):
            resposta['mensagem'] = 'Nenhum resultado encontrado.'
            salvar_log(resposta, respostas_brutas, rota="/")
            return jsonify(resposta), 200
        # 2. Preparar headers para GET
        headers_get = headers_post.copy()
        headers_get.update({"Accept": "application/json"})
        # 3. Headers para imagem
        image_headers = headers_get.copy()
        image_headers.update({
            "Accept": "image/avif,image/webp,image/apng,image/svg+xml,image/*,*/*;q=0.8",
            "Sec-Fetch-Dest": "image",
            "Sec-Fetch-Mode": "no-cors"
        })
        # Processar cada resultado
        dados_list = []
        respostas_brutas["items"] = {}
        all_uf_present = True
        for idx, item in enumerate(data["Data"]):
            first_detail_url = item.get("DetailUrl")
            if not first_detail_url:
                continue
            second_url = f"https://cna.oab.org.br{first_detail_url}"
            response = make_request("GET", second_url, headers=headers_get)
            item_log = {"get_detail": {"rota": second_url, "status": response.status_code, "body": response.text[:1000], "online": True, "erro": ""}}
            second_data = None
            try:
                second_data = response.json()
            except ValueError as e:
                item_log["get_detail"]["erro"] = f"JSON parsing error: {str(e)}"
                respostas_brutas["items"][f"item_{idx}"] = item_log
                continue
            second_detail_url = second_data.get("Data", {}).get("DetailUrl", "")
            if not second_detail_url:
                respostas_brutas["items"][f"item_{idx}"] = item_log
                continue
            third_url = f"https://cna.oab.org.br{second_detail_url}"
            response = make_request("GET", third_url, headers=image_headers)
            item_log["get_image"] = {"rota": third_url, "status": response.status_code, "body": "(Imagem em base64)", "online": True, "erro": ""}
            base64_image = base64.b64encode(response.content).decode('utf-8')
            uf_from_response = item.get("Uf", second_data.get("Data", {}).get("Uf", ""))
            if not uf_from_response:
                all_uf_present = False
            item_dict = {
                "base64_image": base64_image,
                "Nome": item.get("Nome", ""),
                "Inscricao": item.get("Inscricao", ""),
                "Uf": uf_from_response,
                "Situacao": item.get("Situacao", ""),
                "TipoInscricao": item.get("TipoInsc", ""),
                "DetailUrl": first_detail_url
            }
            dados_list.append(item_dict)
            respostas_brutas["items"][f"item_{idx}"] = item_log
        if dados_list:
            mensagem = "Campos Uf, Situacao ou TipoInscricao não retornados." if not all_uf_present else ""
            resposta.update({
                'sucesso': True,
                'mensagem': mensagem,
                'dados': dados_list,
                'base64_image': []
            })
        else:
            resposta['mensagem'] = 'Nenhum resultado com DetailUrl válido.'
            resposta['base64_image'] = []
        salvar_log(resposta, respostas_brutas, rota="/")
        return jsonify(resposta), 200
    except requests.exceptions.RequestException as e:
        respostas_brutas["error"] = {"rota": post_url, "status": 0, "body": "", "online": False, "erro": str(e)}
        resposta['mensagem'] = f'Erro na requisição HTTP: {str(e)}'
        salvar_log(resposta, respostas_brutas, rota="/")
        return jsonify(resposta), 500
    except ValueError as e:
        respostas_brutas["error"] = {"rota": post_url, "status": 0, "body": "", "online": False, "erro": str(e)}
        resposta['mensagem'] = f'Erro ao processar resposta: {str(e)}'
        salvar_log(resposta, respostas_brutas, rota="/")
        return jsonify(resposta), 500
# -------------------------
# Rota Consulta Processos (/consulta)
# -------------------------
@app.route("/consulta", methods=["GET", "POST"])
def consulta():
    oab = request.values.get("oab", "").strip()
    processo = request.values.get("processo", "").strip()
    cpf = request.values.get("cpf", "").strip()
    token = get_token()
  
    if not token:
        resposta = {"error": "Nenhum token encontrado ou fornecido"}
        salvar_log(resposta, {}, rota="/consulta")
        return jsonify(resposta), 401
  
    headers = {
        "Accept": "application/json, text/plain, */*",
   
        "Accept-Language": "pt-BR,pt;q=0.9,en-US;q=0.8,en;q=0.7",
        "Authorization": token,
        "Connection": "keep-alive",
        "Referer": "https://portaldeservicos.pdpj.jus.br/consulta",
        "User-Agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64)"
    }
  
    rotas = {
        "Consulta por OAB": f"https://portaldeservicos.pdpj.jus.br/api/v2/processos?oabRepresentante={requests.utils.quote(oab)}" if oab else "",
        "Consulta por Processo": f"https://portaldeservicos.pdpj.jus.br/api/v2/processos/{processo}" if processo else "",
        "Consulta por CPF/CNPJ": f"https://portaldeservicos.pdpj.jus.br/api/v2/processos?cpfCnpjParte={requests.utils.quote(cpf)}" if cpf else ""
    }
    consulta_solicitada = ""
    if oab:
        consulta_solicitada = "Consulta por OAB"
    elif processo:
        consulta_solicitada = "Consulta por Processo"
    elif cpf:
        consulta_solicitada = "Consulta por CPF/CNPJ"
  
    if not consulta_solicitada:
        resposta = {"error": "Informe oab, processo ou cpf"}
        salvar_log(resposta, {}, rota="/consulta")
        return jsonify(resposta), 400
  
    url = rotas[consulta_solicitada]
    respostas_brutas = {}
  
    if consulta_solicitada == "Consulta por Processo":
        resultado = consultar_api(url, headers)
        respostas_brutas["single"] = resultado
        if not resultado["online"]:
            resposta = {"error": f"Erro na requisição: {resultado['erro']}"}
            salvar_log(resposta, respostas_brutas, rota="/consulta")
            return jsonify(resposta), 500
        try:
            data = json.loads(resultado["body"])
        except json.JSONDecodeError as e:
            resposta = {"error": f"Erro ao parsear JSON: {str(e)}"}
            salvar_log(resposta, respostas_brutas, rota="/consulta")
            return jsonify(resposta), 500
        if isinstance(data, list) and len(data) > 0:
            p = data[0]
        elif isinstance(data, dict):
            p = data
        else:
            resposta = {"error": "Resposta vazia ou inválida"}
            salvar_log(resposta, respostas_brutas, rota="/consulta")
            return jsonify(resposta), 404
        tramitacao_atual = p.get("tramitacaoAtual")
        if not tramitacao_atual:
            resposta = {"error": "Nenhuma tramitação ativa encontrada"}
            salvar_log(resposta, respostas_brutas, rota="/consulta")
            return jsonify(resposta), 404
        partes = processar_partes(tramitacao_atual)
        reformatted = formatar_processo(p, tramitacao_atual, partes)
        resposta = {"response": {"Dados Processados": reformatted}}
        salvar_log(resposta, respostas_brutas, rota="/consulta")
        return jsonify(resposta)
  
    else:
        # Paginação para OAB ou CPF
        processos, total_processos, processos_retornados = [], 0, 0
        contagem_ativo = contagem_passivo = 0
        page_count, max_pages, max_processos = 0, 10, 1000
        search_after = None
        advogado_nomes = {}
        oab_uf = oab[:2] if oab else ""
        oab_numero = oab[2:] if oab else ""
        has_more = True
        while has_more and page_count < max_pages and processos_retornados < max_processos:
            page_count += 1
            current_url = url
            if search_after:
                current_url += '&searchAfter=' + ','.join(map(str, search_after))
            resultado = consultar_api(current_url, headers)
            respostas_brutas[f"pagina_{page_count}"] = resultado
            if not resultado["online"]:
                break
            try:
                data = json.loads(resultado["body"])
            except json.JSONDecodeError:
                break
            if total_processos == 0:
                total_processos = data.get("total", 0)
            content = data.get("content", [])
            for p in content:
                tramitacao_atual = next((t for t in p.get("tramitacoes", []) if t.get("ativo")), None)
                if tramitacao_atual:
                    if consulta_solicitada == "Consulta por OAB":
                        for parte in tramitacao_atual.get("partes", []):
                            if parte.get("polo") == "ATIVO":
                                for rep in parte.get("representantes", []):
                                    if rep.get("tipoRepresentacao") == "ADVOGADO":
                                        for oab_info in rep.get("oab", []):
                                            if str(oab_info.get("numero", "")) == oab_numero and oab_info.get("uf") == oab_uf:
                                                nome_adv = rep.get("nome", "N/A")
                                                advogado_nomes[nome_adv] = advogado_nomes.get(nome_adv, 0) + 1
                    advogado_principal = max(advogado_nomes, key=advogado_nomes.get) if advogado_nomes else ""
                    consulta_tipo = "OAB" if consulta_solicitada == "Consulta por OAB" else "CPF"
                    partes = processar_partes(tramitacao_atual, cpf if consulta_tipo == "CPF" else "", advogado_principal, oab_numero, oab_uf, consulta_tipo)
                    contagem_ativo += partes["contagemAtivo"]
                    contagem_passivo += partes["contagemPassivo"]
                    if processos_retornados < max_processos:
                        if consulta_tipo != "OAB" or (
                            partes["advogadoNoPoloAtivo"]
                            and not partes["advogadoNoPoloPassivo"]
                            and not partes["advogadoComoParteAtiva"]
                            and f"Advogado: {advogado_principal}" in partes["advogados"]
                        ):
                            processos.append(formatar_processo(p, tramitacao_atual, partes))
                            processos_retornados += 1
            search_after = data.get("searchAfter")
            has_more = data.get("numberOfElements", 0) > 0 and search_after is not None
        resposta = {
            "response": {
                "Retornou": f"{processos_retornados} de {total_processos} processos ({contagem_ativo} ativo, {contagem_passivo} passivo)",
                "Processos": processos
            }
        }
        salvar_log(resposta, respostas_brutas, rota="/consulta")
        return jsonify(resposta)
# -------------------------
if __name__ == '__main__':
    app.run(debug=True)